/*
 * Decompiled with CFR 0.152.
 */
package com.github.mahmudindev.mcmod.worldportal.mixin;

import java.util.Map;
import net.minecraft.BlockUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BlockBehaviour.class})
public abstract class BlockBehaviourMixin {
    @Inject(method={"updateShape(Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/core/Direction;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/LevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/state/BlockState;"}, at={@At(value="TAIL")}, cancellable=true)
    private void updateShapeHorizontalPortal(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2, CallbackInfoReturnable<BlockState> cir) {
        int z;
        int x;
        if (!blockState.is(Blocks.END_PORTAL)) {
            return;
        }
        BlockUtil.FoundRectangle foundRectangle = BlockUtil.getLargestRectangleAround((BlockPos)blockPos, (Direction.Axis)Direction.Axis.X, (int)21, (Direction.Axis)Direction.Axis.Z, (int)21, blockPosX -> levelAccessor.getBlockState(blockPosX) == blockState);
        boolean isComplete = true;
        boolean isCustom = false;
        for (x = 0; x < foundRectangle.axis1Size; ++x) {
            for (z = 0; z < foundRectangle.axis2Size; ++z) {
                BlockPos blockPosH = foundRectangle.minCorner.offset(x, 0, z);
                for (Map.Entry<BlockPos, Boolean> entry : Map.of(blockPosH.west(), x == 0, blockPosH.east(), x == foundRectangle.axis1Size - 1, blockPosH.north(), z == 0, blockPosH.south(), z == foundRectangle.axis2Size - 1).entrySet()) {
                    if (!entry.getValue().booleanValue()) continue;
                    BlockState blockStateX = levelAccessor.getBlockState(entry.getKey());
                    if (blockStateX.isAir()) {
                        isComplete = false;
                    }
                    if (!blockStateX.is(Blocks.OBSIDIAN)) continue;
                    isCustom = true;
                }
            }
            if (!isComplete && isCustom) break;
        }
        if (isComplete || !isCustom) {
            return;
        }
        for (x = 0; x < foundRectangle.axis1Size; ++x) {
            for (z = 0; z < foundRectangle.axis2Size; ++z) {
                levelAccessor.setBlock(foundRectangle.minCorner.offset(x, 0, z), Blocks.AIR.defaultBlockState(), 18);
            }
        }
        cir.setReturnValue((Object)Blocks.AIR.defaultBlockState());
    }
}

